/*******************************************************************************
  * @file    KungFu8_I2C.h
  * @author  ChipON Application Team
  * @version V0.0.1
  * @date
  * @brief
  * *
  ******************************************************************************
  */

#ifndef KUNGFU8_I2C_H_
#define KUNGFU8_I2C_H_

//SSCIxCTL0ĴSSCIxMOD<3:0>

#define 	I2C_Slave_Mode_Address_7Bits				(0x06) /*!< 0B0000 0110   I2CӶģʽ, 7 λַ*/
#define 	I2C_Slave_Mode_Address_10Bits				(0x07) /*!< 0B0000 0111   I2CӶģʽ, 10 λַ*/
#define 	I2C_Slave_Mode_Startbit_Stopbit_Addr7Bits	(0x0E) /*!< 0B0000 1110  I2CӶģʽ, 7 λַ,λֹͣλж*/
#define 	I2C_Slave_Mode_Startbit_Stopbit_Addr10Bits	(0x0F) /*!< 0B0000 1111  I2CӶģʽ, 10 λַ,λֹͣλж*/

#define 	I2C_Master_Mode_SCL_UserDefined				(0x08) /*!< 0B0000 1000  I2Cģʽ, ʱ= FOSC/(4*(SSCIxADD+1))*/

#define 	I2C_SSCIMSK_RW_Enabled					    (0x09) /*!< 0B0000 1001     SSCIMSKĴд*/
#define 	I2C_MasterCtrl_SlaveIdle_Mode				(0x0B) /*!< 0B0000 1011  I2C̼ģʽӶģʽ*/


/********************************************************************************************
*								I2C
*
*SCLӦ								SDAӦ
*  P02									P01
*  P03									P02
*  P10                                  P23
**********************************************************************************************/
// demo ݷ
extern s_I2C_RAMBuffer   SSCII2C_DateStruct;


#define  I2C_Add_L  (0xA0)   			// ַλΪ7λʱ 0x50   10λĵ7λ  0xA0
#define  I2C_Add_H  (0xF0 | (0x03<<1) ) // 10λģʽĸ2bit[0~3]λ̶11110
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ӻģʽ
void I2C_Configuration_Slave(void);


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//ģʽI2Cʵ
void I2C_Configuration_Master(void);


//  ݷi2cͨ
uint8  I2C_Write_s_Data();
uint8  I2C_Read_s_Data();

// ͨõĵi2c豸ͨŷӻ࣬ȫֻĴ 豸ĵַ
uint8  I2C_Write_Data(uint8 cAddr,uint8 Length,uint8 * DataAddressPoint);
uint8  I2C_Read_Data(uint8 cAddr,uint8 Length,uint8 * TempAddressPoint);


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//ģʽi2cʹõײ㷽
void I2C_Idle(void);
void I2C_Start(void);
void I2C_ReStart(void);
void I2C_Stop(void);

#define I2C_SendXAck(x) { SSCIACKEN=x; I2C_RSendXAck();}
void I2C_RSendXAck(); // ⲿҪúֵĴ
void I2C_SendAck();
void I2C_SendNAck();

void I2C_SendData(uint8 Data);
uint8 I2C_ReceiveData(void);
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// i2c  ṹ ôʹ10bit7bit֧ʶi2c.hļУҪɵflag==s_uint8
#define  isSampleMode10bits			SSCII2C_DateStruct.flag.bit0  // ǷΪ10bitͨ
#define  isSampleModeMaster			SSCII2C_DateStruct.flag.bit1  // Ƿ
#define  Mode10bitsAddrUAState		SSCII2C_DateStruct.flag.bit7  // 10bitҪµַģ״̬
#define  isSampleRevCommandAddr		SSCII2C_DateStruct.flag.bit6  // Эı׼EEpromЭĽ8bitַ־


#endif /* KUNGFU8_I2C_H_ */
